/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.gui.GUIBeastiary;
import com.lycanitesmobs.core.gui.GUICreature;
import com.lycanitesmobs.core.gui.GUIFamiliar;
import com.lycanitesmobs.core.gui.GUILMMainMenu;
import com.lycanitesmobs.core.gui.GUIMinion;
import com.lycanitesmobs.core.gui.GUIMinionSelection;
import com.lycanitesmobs.core.gui.GUIMountManager;
import com.lycanitesmobs.core.gui.GUIPetManager;
import com.lycanitesmobs.core.inventory.ContainerCreature;
import com.lycanitesmobs.core.tileentity.TileEntityBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class GuiHandler
implements IGuiHandler {
    public static GuiHandler instance;

    public GuiHandler() {
        instance = this;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id == GuiType.TILEENTITY.id) {
            TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
            if (tileEntity instanceof TileEntityBase) {
                return ((TileEntityBase)tileEntity).getGUI(player);
            }
        } else if (id == GuiType.ENTITY.id) {
            Entity entity = world.func_73045_a(x);
            if (entity instanceof EntityCreatureBase) {
                return new ContainerCreature((EntityCreatureBase)entity, player.field_71071_by);
            }
        } else if (id != GuiType.ITEM.id && id == GuiType.PLAYER.id) {
            return null;
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id == GuiType.TILEENTITY.id) {
            TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
            if (tileEntity instanceof TileEntityBase) {
                return ((TileEntityBase)tileEntity).getGUI(player);
            }
        } else if (id == GuiType.ENTITY.id) {
            Entity entity = world.func_73045_a(x);
            if (entity instanceof EntityCreatureBase) {
                return new GUICreature((EntityCreatureBase)entity, player.field_71071_by);
            }
        } else if (id != GuiType.ITEM.id && id == GuiType.PLAYER.id) {
            if (x == PlayerGuiType.LM_MAIN_MENU.id) {
                return new GUILMMainMenu(player);
            }
            if (x == PlayerGuiType.BEASTIARY.id) {
                return new GUIBeastiary(player);
            }
            if (x == PlayerGuiType.PET_MANAGER.id) {
                return new GUIPetManager(player);
            }
            if (x == PlayerGuiType.MOUNT_MANAGER.id) {
                return new GUIMountManager(player);
            }
            if (x == PlayerGuiType.FAMILIAR_MANAGER.id) {
                return new GUIFamiliar(player);
            }
            if (x == PlayerGuiType.MINION_MANAGER.id) {
                return new GUIMinion(player, y);
            }
            if (x == PlayerGuiType.MINION_SELECTION.id) {
                return new GUIMinionSelection(player);
            }
        }
        return null;
    }

    public static enum PlayerGuiType {
        LM_MAIN_MENU(0),
        BEASTIARY(1),
        PET_MANAGER(2),
        MOUNT_MANAGER(3),
        FAMILIAR_MANAGER(4),
        MINION_MANAGER(5),
        MINION_SELECTION(6);

        public byte id;

        private PlayerGuiType(byte i) {
            this.id = i;
        }
    }

    public static enum GuiType {
        TILEENTITY(0),
        ENTITY(1),
        ITEM(2),
        PLAYER(3);

        public byte id;

        private GuiType(byte i) {
            this.id = i;
        }
    }
}

